/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;

public final class VWLibraryType {
    private static final int MIN_LIBRARY_TYPE = 0;
    public static final int LIBRARY_TYPE_UNDEFINED = 0;
    public static final int LIBRARY_TYPE_IDMIS = 1;
    public static final int LIBRARY_TYPE_IDMDS = 2;
    public static final int LIBRARY_TYPE_CONTENT_ENGINE = 3;
    public static final int LIBRARY_TYPE_CM = 4;
    public static final int LIBRARY_TYPE_OD = 5;
    public static final int LIBRARY_TYPE_GENERIC = 6;
    private static final int MAX_LIBRARY_TYPE = 6;
    private static String[] NormalStrings = new String[]{"Undefined", "IDMIS", "IDMDS", "Content Engine", "CM8", "CM OnDemand", "Generic"};
    private static String[] LocalizedStrings = new String[]{new VWString("vw.api.VWLibraryTypeUndef", "Undefined").toString(), new VWString("vw.api.VWLibraryTypeIDMIS", "IDMIS").toString(), new VWString("vw.api.VWLibraryTypeIDMDS", "IDMDS").toString(), new VWString("vw.api.VWLibraryTypeContentEngine", "Content Engine").toString(), new VWString("vw.api.VWLibraryTypeCM8", "CM8").toString(), new VWString("vw.api.VWLibraryTypeOD", "CM OnDemand").toString(), new VWString("vw.api.VWLibraryTypeGeneric", "Generic").toString()};

    public static String _get_FILE_DATE() {
        return "$Date: 2009-07-07 20:03:36 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/1 $";
    }

    public static String getLocalizedString(int theLibraryType) throws VWException {
        if (!VWLibraryType.isValid(theLibraryType)) {
            throw new VWException("vw.api.VWLibraryTypeBadInteger", "Integer form of the Library type is invalid: {0}", String.valueOf(theLibraryType));
        }
        return LocalizedStrings[theLibraryType - 0];
    }

    public static boolean isValid(int theLibraryType) {
        return theLibraryType >= 0 && theLibraryType <= 6;
    }

    protected static String typeToString(int theLibraryType) throws VWException {
        if (VWLibraryType.isValid(theLibraryType)) {
            return NormalStrings[theLibraryType - 0];
        }
        throw new VWException("vw.api.VWLibraryTypeBadInteger", "Integer form of the Library type is invalid: {0}", String.valueOf(theLibraryType));
    }

    protected static int stringToType(String theLibraryType) throws VWException {
        for (int i = 0; i < NormalStrings.length; ++i) {
            if (!theLibraryType.equals(NormalStrings[i])) continue;
            return i + 0;
        }
        throw new VWException("vw.api.VWLibraryTypeBadString", "String form of the Library type is invalid: {0}", theLibraryType);
    }
}

